/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWModeType {
    private static final int MIN_MODE_TYPE = 1;
    public static final int MODE_TYPE_IN = 1;
    public static final int MODE_TYPE_OUT = 2;
    public static final int MODE_TYPE_IN_OUT = 3;
    private static final int MAX_MODE_TYPE = 3;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWModeTypeIn", "Read").toString(), new VWString("VW.api.VWModeTypeOut", "Write").toString(), new VWString("VW.api.VWModeTypeInOut", "Read/Write").toString()};

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:36  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.20  $";
    }

    public static String getLocalizedString(int theModeType) throws VWException {
        if (!VWModeType.isValid(theModeType)) {
            throw new VWException("vw.api.VWModeTypeBadInteger", "Integer form of the mode type is invalid: {0}", String.valueOf(theModeType));
        }
        return LocalizedStrings[theModeType - 1];
    }

    public static boolean isValid(int theModeType) {
        return theModeType >= 1 && theModeType <= 3;
    }

    protected static String typeToString(int modeType) throws VWException {
        switch (modeType) {
            case 1: {
                return "in";
            }
            case 2: {
                return "out";
            }
            case 3: {
                return "inout";
            }
        }
        throw new VWException("vw.api.VWModeTypeBadInteger", "Integer form of the mode type is invalid: {0}", String.valueOf(modeType));
    }

    protected static int stringToType(String modeType) throws VWException {
        if (modeType.equals("in")) {
            return 1;
        }
        if (modeType.equals("out")) {
            return 2;
        }
        if (modeType.equals("inout")) {
            return 3;
        }
        throw new VWException("vw.api.VWModeTypeBadString", "String form of the mode type is invalid: {0}", modeType);
    }
}

